# FILE:    rule_of_thumb_1.R
# AUTHOR:  Pete Versteegen
# DATE:    9 March 2014
# PURPOSE: Determine the distribution of water depths for the boat slips.
#========1=========2=========3=========4=========5=========6=========7=========8=========9=========0

source("../functions/credit.R")

#========1=========2=========3=========4=========5=========6=========7=========8=========9=========0
lake_volume <- function(L){
	# V = Lake Volume, acre-feet
	# L = Lake Level, ft ASL
	V <- 1.0511467e+7 - 8696.767 * L + 1.798918 * L^2
	return(V)
}


lake_area <- function(L){
	# A = Lake Area, acres
	# L = Lake Level, ft ASL
	A <- 1.051147e+7 - 8696.767 * L + 1.798918 * L^2
	return(A)
}


#========1=========2=========3=========4=========5=========6=========7=========8=========9=========0

# Generate the lake level values for which things are to be evaluated

# Lake levels
level <- seq(2456, 2462, by=0.25)

# Compute lake volumes at the lake levels
volume <- vector()
i <- 0
for( lev in level){
	i <- i + 1
	volume[i] <- lake_volume(lev)
}

# Plot volume vs.level
plot(level, volume, main="Lake Volume as a Function of Lake Level",
	 xlab="Lake Level, ft ASL", ylab="Lake Volume, acre-feet")
grid(col="black")

# Define the generator flows that have been banded about
genflow <- vector()
genflow[1] <- 600
genflow[2] <- 620
genflow[3] <- 640
genflow[4] <- 680
genflow


# Compute the lake areas are the specified lake levels
area <- vector()
i <- 0
for( lev in level ){
	i <- i + 1
	area[i] <- lake_area(lev)
}
area

# Plot lake areas
plot(level, area, main="Lake Area as a Function of Lake Level",
	 xlab="Lake Level, ft ASL", ylab="Lake area, acres")
grid(col="black")

#========1=========2=========3=========4=========5=========6=========7=========8=========9=========0

# Compute the generator consumptions at the defined lake levels 
# and the associated lake level drop
color <- c("green", "red", "blue", "purple")
titletext <- "Lake level drop/hr of turbine generation at indicated lake level"
h <- vector()
for(k in 1:length(genflow)){
	flow.hr <- genflow[k] * 3600
	for(i in 1:length(level)){
		A <- area[i] * 43560.0
		print(A)
		h[i] <- flow.hr / A
		print(h*12.)
	}
	if(k == 1) {
		plot(level, h*12, type="o", col=color[k], main=titletext,
		xlab="Lake Level, ft ASL", ylab="Lake Level Drop, inches")
		grid(col="black")
		credit("rule_of_thumb.R")
		legend(x="bottomleft", legend=c("600 cfs", "620 cfs", "640 cfs", "680 cfs"),
		       col=color, lwd=1.1, pch=21, bg="cornsilk")
	} else {
		points(level, h*12, type="o", col=color[k])
	}

}
#========1=========2=========3=========4=========5=========6=========7=========8=========9=========0
